//
//  GSDocument+SerialImport.h
//  Glyphs
//
//  Created by Georg Seifert on 12.09.12.
//  Copyright (c) 2012 schriftgestaltung.de. All rights reserved.
//

#import <GlyphsCore/GSFont.h>
#import <GlyphsCore/GSFontMaster.h>
#import <GlyphsCore/GSGlyph.h>
#import <GlyphsCore/GSNode.h>
#import <GlyphsCore/GSPath.h>

#import <GlyphsCore/CFOldStylePList.h>

#ifdef GLYPHS_VIEWER_
// to make the objects link property
extern NSString *SerialImportCategory;
#endif

NS_ASSUME_NONNULL_BEGIN

@interface GSFont (SerialImport)

- (instancetype)initWithGlyphsFileAtPath:(NSString *)path error:(out NSError **)outError;

#ifndef QUICKLOOK
- (BOOL)convertKerning:(NSError**)error;
#endif

@end

@interface GSGlyph (SerialImport)

- (instancetype)initWithFile:(nonnull NSString *)filePath format:(GSFormatVersion)format error:(out NSError **)error;

- (instancetype)initWithGlyphsParser:(GSPlistParseInfo *)pInfo format:(GSFormatVersion)formatVersion;

@end

@interface GSPath (SerialImport)

- (instancetype)initWithGlyphsParser:(GSPlistParseInfo *)pInfo format:(GSFormatVersion)formatVersion;

@end

@interface GSNode (SerialImport)

- (instancetype)initWithGlyphsParser:(GSPlistParseInfo *)pInfo format:(GSFormatVersion)formatVersion;

@end

@interface GSFontMaster (SerialImport)

- (instancetype)initWithGlyphsParser:(GSPlistParseInfo *)pInfo format:(GSFormatVersion)formatVersion;

- (BOOL)postRead:(out NSError **)error format:(GSFormatVersion)formatVersion;

@end

NS_ASSUME_NONNULL_END
